function Vector2(_x, _y)
	return { x = _x, y = _y };
end

scenelist =
{	
	-- module one scenes
	{ "M1: Flo's Diner", "quest/m1_diner/", "m1_diner" }, -- the scene you go to on a new game
	
	{ "M1: Beauty Salon", "quest/m1_beauty/", "m1_beauty" },
	{ "M1: Beauty Salon Drawer", "quest/m1_beautydrawer/", "m1_beautydrawer" },
	{ "M1: Dress Shop", "quest/m1_dress/", "m1_dress" },
	{ "M1: Dress Shop Instructions", "quest/m1_dress_instructions/", "m1_dress_instructions" },
	{ "M1: Dress Shop Panel", "quest/m1_dresspanel/", "m1_dresspanel" },
	{ "M1: Florida St", "quest/m1_florida/", "m1_florida" },
	{ "M1: Intersection", "quest/m1_intersection/", "m1_intersection" },
	{ "M1: Pet Shop", "quest/m1_petshop/", "m1_petshop" },
	{ "M1: Pet Spa", "quest/m1_petspa/", "m1_petspa" },
	{ "M1: Safe", "quest/m1_safe/", "m1_safe" },
	{ "M1: Spend-a-lot Ave 1", "quest/m1_spendalot1/", "m1_spendalot1" },
	{ "M1: Spend-a-lot Ave 2", "quest/m1_spendalot2/", "m1_spendalot2" },
	
	-- module two scenes
	{ "GOTO MODULE 2", "quest/subway/", "goto_module2" },
	{ "M2: Bakery", "quest/m2_bakery/", "m2_bakery" },
	{ "M2: Bakery Kitchen", "quest/m2_kitchen/", "m2_kitchen" },
	{ "M2: Bakery Kitchen Drawer", "quest/m2_kitchendrawer/", "m2_kitchendrawer" },
	{ "M2: Bakery Kitchen Cabinet", "quest/m2_kitchencabinet/", "m2_kitchencabinet" },
	{ "M2: Fitness Center", "quest/m2_fitness/", "m2_fitness" },
	{ "M2: Fitness Center VCR", "quest/m2_vcr/", "m2_vcr" },
	{ "M2: Intersection", "quest/m2_intersection/", "m2_intersection" },
	{ "M2: Sizzle St 1", "quest/m2_sizzle1/", "m2_sizzle1" },
	{ "M2: Sizzle St 2", "quest/m2_sizzle2/", "m2_sizzle2" },
	{ "M2: Smith's Farm", "quest/m2_farm/", "m2_farm" },
	{ "M2: Sunny Side Rd", "quest/m2_sunnyside/", "m2_sunnyside" },
	
	-- module three scenes
	{ "GOTO MODULE 3", "quest/subway/", "goto_module3" },
	{ "M3: Flo's Apartment", "quest/m3_apartment/", "m3_apartment" },
	{ "M3: Flo's Apartment Closeup", "quest/m3_apartment_closeup/", "m3_apartment_closeup" },
	{ "M3: Big Ave", "quest/m3_big/", "m3_big" },
	{ "M3: Big Corp Lobby", "quest/m3_lobby/", "m3_lobby" },
	{ "M3: Big Corp Permits Office", "quest/m3_permits/", "m3_permits" },
	{ "M3: Big Corp Signatures Office", "quest/m3_signatures/", "m3_signatures" },
	{ "M3: Cruise Ship", "quest/m3_ship/", "m3_ship" },
	{ "M3: Cubicle Maze1", "quest/m3_maze1/", "m3_maze1" },
	{ "M3: Landing 13", "quest/m3_landing13/", "m3_landing13" },	
	{ "M3: Cubicle Maze2", "quest/m3_maze2/", "m3_maze2" },
	{ "M3: Landing 50", "quest/m3_landing50/", "m3_landing50" },
	{ "M3: Cubicle Maze3", "quest/m3_maze3/", "m3_maze3" },
	{ "M3: Flower Shop", "quest/m3_flowershop/", "m3_flowershop" },
	{ "M3: Gravy Boat Way", "quest/m3_gravyboat/", "m3_gravyboat" },
	{ "M3: Intersection", "quest/m3_intersection/", "m3_intersection" },
	{ "M3: Pancake Rd", "quest/m3_pancake/", "m3_pancake" },
	
	-- mini-game scenes
	{ "MG: Aerobics", "quest/mg_aerobics/", "mg_aerobics" },
	{ "MG: Beading", "quest/mg_bead/", "mg_bead" },
	{ "MG: Chicken Chorus", "quest/mg_chickenchorus/", "mg_chickenchorus" },
	{ "MG: Chicken Field", "quest/mg_chickenfield/", "mg_chickenfield" },
	{ "MG: Clothing Display", "quest/mg_clothing/", "mg_clothing" },
	{ "MG: Doughball", "quest/mg_doughball/", "mg_doughball" },
	{ "MG: Flower Shop", "quest/mg_flower/", "mg_flower" },
	{ "MG: Pet Supply Package", "quest/mg_package/", "mg_package" },
	{ "MG: Pizza Puzzle", "quest/mg_pizza/", "mg_pizza" },
	{ "MG: Triangle Lock", "quest/mg_triangle/", "mg_triangle" },
	
	-- general scenes
	{ "Recycle Machine", "quest/recyclemachine/", "recyclemachine" },
	{ "Subway Map", "quest/subwaymap/", "subwaymap" },
	{ "Flo's Purse", "quest/purse/", "purse" },
	{ "Napkin", "quest/napkin/", "napkin" },
	{ "Map", "quest/map/", "map" },
	{ "Subway", "quest/subway/", "subway" },
	{ "Butterfly List", "quest/butterflylist/", "butterflylist" },
	{ "Activity Complete Dialog", "quest/activity_mode/", "activity_complete_dialog" },
	
	-- testing scene
	{ "TESTING", "quest/testing/", "testing" },
 };
 
cursorlist =
{
	{ "cursor_use",			"cursor/cursor_use", 12,15 },
	{ "cursor_use_glow",		"cursor/cursor_use", 12,15 },
	{ "cutscene",			"cursor/cutscene", 14,13 },
	{ "cursor_glow",			"cursor/cursor_glow", 1, 1 },
	{ "cursor",				"cursor/cursor", 1, 1 },
	{ "cursor_inactive",		"cursor/cursor_inactive", 1, 1 },
	{ "prohibited",			"cursor/cursor_prohibited", 1, 1 },
	{ "thumb",				"cursor/thumb", 12, 2 },
	{ "book",				"cursor/cursor_book", 16, 19 },
	{ "cursor_object",		"cursor/cursor_glow", 1, 1  },
	{ "cursor_exit",			"cursor/cursor_exit", 16, 1 },
	{ "cursor_arrow_e",		"cursor/cursor_arrow_e", 32, 32 },
	{ "cursor_arrow_ne",		"cursor/cursor_arrow_ne", 32, 32 },
	{ "cursor_arrow_n",		"cursor/cursor_arrow_n", 32, 32 },
	{ "cursor_arrow_nw",		"cursor/cursor_arrow_nw", 32, 32 },
	{ "cursor_arrow_s",		"cursor/cursor_arrow_s", 32, 32 },
	{ "cursor_arrow_sw",		"cursor/cursor_arrow_sw", 32, 32 },
	{ "cursor_arrow_w",		"cursor/cursor_arrow_w", 32, 32 },
	{ "cursor_closed_hand",	"cursor/cursor_closed_hand", 5, 5 },
	{ "cursor_open_hand",		"cursor/cursor_open_hand", 11, 17 },
};

awardlist =
{
	-- keyname/bitmapname  points value
	{ "avenue-flo_weddingdress",		10 },
	{ "avenue-flo_snookums",		10 },
	{ "avenue-flo_weddingcake",		10 },
	{ "avenue-flo_bouquets",		10 },
	{ "avenue-flo_butterflies",		10 },
	{ "avenue-flo_recycle",			10 },
	{ "avenue-flo_weddingrings",		10 },
	{ "avenue-flo_finish",			10 },
	{ "avenue-flo_beadingmaster",	10 },
	{ "avenue-flo_clothingdisplay",	10 },
	{ "avenue-flo_packaging",		10 },
	{ "avenue-flo_chickenchaser",	10 },
	{ "avenue-flo_chickenconductor",	10 },
	{ "avenue-flo_doughballwrangler",	10 },
};

-- butterfly numbers to search for in each scene
butterfly_numbers = 
{
	m1_florida = {"001", "002", "003", "004", "005", "006", "007", "008", "026", "027", "028"},
	m1_intersection = {"009", "010", "011", "029"},
	m1_spendalot1 = {"012", "013", "014", "015", "016", "017", "018", "030", "031"},
	m1_spendalot2 = {"019", "020", "021", "022", "023", "024", "025", "032", "033"},
	m2_sizzle1 = {"034", "035", "036", "037", "038", "039", "040", "041", "042", "043", "044"},
	m2_sizzle2 = {"045", "046", "047", "048", "049"},
	m2_intersection = {"050", "051", "053", "054", "055"},
	m2_sunnyside = {"056", "058", "059", "060", "061", "062", "063", "065", "066"},
	m2_farm = {"052", "057", "064"},
	m3_big = {"067", "068", "069", "070", "071", "072", "073", "074", "075", "076", "077", "080", "081", "082"},
	m3_intersection = {"079", "084", "085", "086", "087", "088",},
	m3_pancake = {"078", "083","089", "090", "091", "092", "093", "094", "095", "096", "097", "098", "099"},
};


-- define recyclable spawning control variables
recyclable_info = 
{
	max_verts = 20, -- the number of potential recyclable verts to spawn at in a scene
	max_types = 3, -- maximum variations in recyclable images and halos
	scene_total = 
	{
		-- module 1
		m1_intersection	= 3,
		m1_florida		= 5,
		m1_spendalot1	= 6,
		m1_spendalot2	= 6,
		
		-- module 2
		m2_intersection	= 4,
		m2_sizzle1		= 10,
		m2_sizzle2		= 6,
		m2_sunnyside	= 12,
		m2_farm		= 3,
		
		-- module 3
		m3_intersection	= 5,
		m3_big		= 5,
		m3_pancake	= 7,
		m3_gravyboat	= 3,
	},
};